package com.ejie.ab04b.dao;

import java.util.List;

import com.ejie.ab04b.model.Obra;
import com.ejie.ab04b.model.solicitud.SolicObra;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * ObraDao generated by UDA, 22-feb-2017 8:54:47.
 * 
 * @author UDA
 */

public interface ObraDao {

	/**
	 * Inserts a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the obra
	 */
	Obra add(Obra ab0482s00);

	/**
	 * Inserts a single row in the Obra table.
	 * 
	 *  obra
	 *            Obra
	 *  solicitud
	 *            Obra
	 *  Obra
	 *
	 * @param obra the obra
	 * @param solicitud the solicitud
	 * @return the obra
	 */
	Obra addFromSolicitud(Obra obra, SolicObra solicitud);

	/**
	 * Inserts a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the obra
	 */
	Obra addPresencial(Obra ab0482s00);

	/**
	 * Updates a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the obra
	 */
	Obra update(Obra ab0482s00);

	/**
	 * Updates a single row in the Obra table.
	 * 
	 *  obra
	 *            Obra
	 *  Obra
	 *
	 * @param obra the obra
	 * @return the obra
	 */
	Obra modificarObraTabDatosObra(Obra obra);

	/**
	 * Finds a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the obra
	 */
	Obra find(Obra ab0482s00);

	/**
	 * Finds a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the obra
	 */
	Obra findByExpediente(Obra ab0482s00);

	/**
	 * Removes a single row in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 */
	void remove(Obra ab0482s00);

	/**
	 * Finds a List of rows in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<Obra> findAll(Obra ab0482s00, JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Obra table using like.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<Obra> findAllLike(Obra ab0482s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Obra table.
	 * 
	 *  filterObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	void removeMultiple(Obra filterObra, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Counts rows in the Obra table using like.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	Long findAllLikeCount(Obra ab0482s00, Boolean startsWith);

	/**
	 * Counts rows in the Obra table.
	 * 
	 *  ab0482s00
	 *            Obra
	 *  Long
	 *
	 * @param ab0482s00 the ab 0482 s 00
	 * @return the long
	 */
	Long findAllCount(Obra ab0482s00);

	/**
	 * Reorder selection.
	 * 
	 *  filterObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Obra>>
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<Obra>> reorderSelection(Obra filterObra,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 *  filterObra
	 *            Obra
	 *  searchObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<TableRowDto<Obra>>
	 *
	 * @param filterObra the filter obra
	 * @param searchObra the search obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	List<TableRowDto<Obra>> search(Obra filterObra, Obra searchObra,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Obra table.
	 * 
	 *  filterObra
	 *            Obra
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<JerarquiaDto<Obra>>
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<JerarquiaDto<Obra>> findAllLikeJerarquia(Obra filterObra,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy.
	 * 
	 *  filterObra            Obra
	 *  jqGridRequestDto            JQGridRequestDto
	 *  Long
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the long
	 */
	Long findAllLikeCountJerarquia(Obra filterObra,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows.
	 * 
	 *  filterObra            Obra
	 *  jqGridRequestDto            JQGridRequestDto
	 *  List<TableRowDto<Obra>>
	 *
	 * @param filterObra the filter obra
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	List<TableRowDto<Obra>> findAllChild(Obra filterObra,
			JQGridRequestDto jqGridRequestDto);

}
